/*************************************************************************
 * DISCLAIMER                                                            *
 * Services performed by FREESCALE in this matter are performed          *
 * AS IS and without any warranty. CUSTOMER retains the final decision   *
 * relative to the total design and functionality of the end product.    *
 * FREESCALE neither guarantees nor will be held liable by CUSTOMER      *
 * for the success of this project. FREESCALE disclaims all warranties,  *
 * express, implied or statutory including, but not limited to,          *
 * implied warranty of merchantability or fitness for a particular       *
 * purpose on any hardware, software ore advise supplied to the project  *
 * by FREESCALE, and or any product resulting from FREESCALE services.   *
 * In no event shall FREESCALE be liable for incidental or consequential *
 * damages arising out of this agreement. CUSTOMER agrees to hold        *
 * FREESCALE harmless against any and all claims demands or actions      *
 * by anyone on account of any damage, or injury, whether commercial,    *
 * contractual, or tortuous, rising directly or indirectly as a result   *
 * of the advise or assistance supplied CUSTOMER in connection with      *
 * product, services or goods supplied under this Agreement.             *
 *************************************************************************/
/*******************************************************************
  Copyright (c) 2011 Freescale Semiconductor
  \file     	Main.c
  \brief    	Smart Card Reader for MC9S08JM60
  \author   	Freescale Semiconductor
  \version    0.2
  \date     	16/Aug/2011
*********************************************************************/

/* Include Files */
#include <hidef.h>          /* for EnableInterrupts macro */
#include "derivative.h"     /* include peripheral declarations */
#include "Usb_Drv.h"        /* USB Main Driver */
#include "Usb_Config.h"     /* USB Configuration header */
#include "FSLTypes_File.h"  /* FSL Standar Definitions */
#include "MCU.h"            /* MCU Initialization */
#include "GPIO.h"           /* GPIO Initialization */
#include "USB_User_API.h"   /* USB API for USB Module */
#include "SCI.h"            /* SCI Initialization */
#include "CLK.h"            /* TPM Initialization */
#include "SmartCard.h"      /* Smart Card Initialization */

#pragma MESSAGE DISABLE C1420 // Result of function call is ignored
//#pragma MESSAGE DISABLE C4000 // Condition always true
//#pragma MESSAGE DISABLE C5702 // Local variable not referenced

// Prototypes
void Init_Sys(void);
void USB_servo(void);

void main(void){ 
  byte temp = 0;
  word i=0;
  
  // System Initalization
  Init_Sys();               

  EnableInterrupts;         

  SC_Start();
  
  for(;;)
  {                              
    i=100;               //  delay about 1000->1.7 mS
    while(i--)
    {
      __RESET_WATCHDOG();
    }

    USB_servo();
    SC_servo();

  } // for loop
  
}


/*****************************************************************************
 * Init_Sys: Initialize the system
 * Input: 	None
 * Output: None
 * Parameters: None
 *
 ****************************************************************************/
void Init_Sys(void)
{
	Mcu_Init();               // MCU general Initialization
	MCG_Init();	              // Initialize the MCG module to generate 24MHz bus clock
  GPIO_Init();
  CLK_Init();
  SCI1_Init();
  SC_Init();
	Initialize_USBModule();   // Initialize USB Module
	//PTBDD_PTBDD4 = 1;
}

/*********************/
void USB_servo(void)
{  
  unsigned char i;
  // USB Manager, please keep it in main Loop
  Check_USBBus_Status();                
      
  if(CheckEndPointOUT(EP1))   
  {       
     // If data was received in EP1, set LEDs value 
     LED4 = ~(EP1_Buffer[0]);        
     LED5 = ~(EP1_Buffer[0] >> 1);
     LED6 = ~(EP1_Buffer[0] >> 2);
     LED7 = ~(EP1_Buffer[0] >> 3);
        
  }

  else if (CheckEndPointOUT(EP3))
  {
     //check first byte (command)
    LED7 = ~LED7;  
    
    for(i = 0;i <= EP3_Buffer[0];i ++)
    {
      sc_cmd_buffer[i] = EP3_Buffer[i];   
    }
    
    sc_cmd_status = SC_CMD_RECEIVED;
     
  }
}








